

/**
 * Je suis un consommateur qui consomme des instances de la classe Product. Je recupere les produits d'une instance de la classe Stock.
 * 
 * @author F.Dagnat
 * @version 2
 */

public class Consumer extends Actor {

	/**
	 * Chaque consommateur est lie a un Stock qui lui est attribue a sa creation
	 */
	private final Stock myStock;

	/**
	 * Construit un consommateur en lui attribuant un nom et un Stock.
	 * 
	 * @param name le nom du consommateur
	 * @param Stock le Stock qui lui est attribue
	 * @throws NullPointerException si un des parametres n'est pas initialise
	 */
	public Consumer(String name, Stock stock) {
		super(name);
		if (name == null || stock == null)
			throw new NullPointerException();
		this.myStock = stock;
	}

	/**
	 * Un consommateur consome en enlevant le dernier produit disponible dans le Stock.
	 */
	public void consume() {
		Product p = this.myStock.remove();
		System.out.println("Consomme " + p);
	}

	/**
	 * Rend le Stock associe au consommateur
	 */
	public Stock getStock() {
		return this.myStock;
	}

	/**
	 * Rend une chaine qui decrit les caracteristiques du consommateur
	 */
	@Override
	public String toString() {
		return "Consommateur " + this.getName();
	}
}
