

/**
 * Je suis un producteur qui produit des instances de la classe Product. Je range ma production dans une instance de la classe Stock.
 * 
 * @author F.Dagnat
 * @version 2
 */

public class Producer extends Actor {

	/**
	 * Chaque producteur est lie a un Stock qui lui est attribue a sa creation
	 */
	private final Stock myStock;

	/**
	 * Construit un producteur en lui attribuant un nom et un Stock.
	 * 
	 * @param name le nom du producteur
	 * @param Stock le Stock qui lui est attribue
	 * @throws NullPointerException si un des parametres n'est pas initialise
	 */
	public Producer(String name, Stock stock) {
		super(name);
		if (name == null || stock == null)
			throw new NullPointerException();
		this.myStock = stock;
	}

	/**
	 * Rend le Stock associe au producteur
	 */
	public Stock getStock() {
		return this.myStock;
	}

	/**
	 * Un Producteur produit en mettant un nouveau produit dont le nom est passe en argument dans le Stock.
	 * 
	 * @param productName le nom du produit a produire
	 */
	public void produce(String productName) {
		if (productName != null)
			this.myStock.add(new Product(productName));
	}

	/**
	 * Rend une chaine qui decrit les caracteristiques du producteur.
	 */
	@Override
	public String toString() {
		return "Producteur " + this.getName();
	}
}
