

/**
 * Classe repr&eacute;sentant un produit. Un produit poss&egrave;de un nom et un
 * num&eacute;ro qui correspond &agrave; son rang de cr&eacute;ation. Il est
 * possible de r&eacute;cup&eacute;rer ce nom, ce num&eacute;ro et de
 * transformer un produit en cha&icirc;ne de caract&egrave;res. Il est
 * &eacute;galement possible de savoir le nombre de produits d&eacute;j&agrave;
 * cre&eacute;s.
 * 
 * @author F.Dagnat
 * @version 2
 */
public class Product {
	/**
	 * Nom du produit.
	 */
	private final String name;

	/**
	 * Nombre de produits d&eacute;j&agrave; cre&eacute;s. Permet d'attribuer un
	 * num&eacute;ro &agrave; chaque produit, ce num&eacute;ro est
	 * increment&eacute; &agrave; chaque instanciation
	 */
	private static int numberCreated = 0;

	/** Le num&eacute;ro du produit */
	private final int number;

	/**
	 * Constructeur qui prend en param&egrave;tre le nom du nouveau produit
	 * 
	 * @param nom
	 *            du produit &agrave; cr&eacute;er
	 */
	public Product(String name) {
		this.name = name;
		this.number = ++numberCreated;
	}

	/**
	 * Rend une cha&icirc;ne de caract&egrave;res qui est le nom du produit
	 * 
	 * @return le nom du produit
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * Rend le num&eacute;ro du produit
	 * 
	 * @return num&eacute;ro du produit
	 */
	public int getNumber() {
		return this.number;
	}

	/**
	 * Rend une cha&icirc;ne de caract&egrave;res qui d&eacute;crit le produit
	 */
	@Override
	public String toString() {
		return "Produit " + this.name + " de num " + this.number;
	}

	/**
	 * Rend le nombre de produits cre&eacute;s
	 * 
	 * @return nombre de produits cre&eacute;s
	 */
	public static int getNumberCreated() {
		return numberCreated;
	}
}
