

/**
 * Un Stock d'instances de Product dont la taille est fixee a la creation.
 * 
 * @author F.Dagnat
 * @version 2
 */
public class Stock {
	/** taille par defaut du tableau de produits **/
	private final int DEFAULT_SIZE = 1;

	/** le tableau contenant les produits */
	private final Product[] content;

	/** le nombre de produits deposes */
	private int size = 0;

	/**
	 * un constructeur avec comme parametre la taille du Stock
	 * 
	 * @param s la taille du Stock
	 */
	public Stock(int s) {
		if (s > 0) {
			this.content = new Product[s];
			return;
		}
		this.content = new Product[DEFAULT_SIZE];
	}

	/**
	 * rajoute un nouveau produit dans le Stock
	 * 
	 * @param p le produit qui est rajoute
	 */
	public void add(Product p) {
		if (p == null)
			return;

		if (!isFull())
			this.content[this.size++] = p;
	}

	/**
	 * retire le <b>dernier</b> produit ajoute au Stock et le rend en resultat
	 */
	public Product remove() {
		Product p = null;
		if (!isEmpty()) {
			p = this.content[--this.size];
			this.content[this.size] = null;
		}
		return p;
	}

	/** rend une chaine de caracteres decrivant le Stock */
	@Override
	public String toString() {
		if (isEmpty())
			return "Le Stock est vide.";
		String s = "Le Stock contient : ";
		for (int i = 0; i < this.size; i++)
			s += "\n\t" + this.content[i];
		return s;
	}

	/** permet de savoir si le Stock est vide */
	private boolean isEmpty() {
		return this.size == 0;
	}

	/** permet de savoir si le Stock plein */
	private boolean isFull() {
		return this.size == this.content.length;
	}
}
