/*
 * @author j.n.magee 16/4/98 modified by F. Dagnat
 */
package display;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class DisplayedNumber extends Canvas {
	private int value = 0;
	private final String title;

	public DisplayedNumber(String title) {
		this(title, Config.passColor);
	}

	public DisplayedNumber(String title, Color c) {
		this.title = title;
		setBackground(c);
		setSize(150, 100);
	}

	public void decrValue() {
		this.value--;
		repaint();
	}

	public void decrValue(int i) {
		this.value -= i;
		repaint();
	}

	public int getValue() {
		return this.value;
	}

	public void incrValue() {
		this.value++;
		repaint();
	}

	public void incrValue(int i) {
		this.value += i;
		repaint();
	}

	@Override
	public void paint(Graphics g) {
		g.setColor(Color.black);
		// Display the title
		g.setFont(Config.titleFont);
		FontMetrics fm = g.getFontMetrics();
		int w = fm.stringWidth(this.title);
		int x = (getSize().width - w) / 2;
		int y = fm.getHeight();
		g.drawString(this.title, x, y);
		// g.drawLine(x, y + 3, x + w, y + 3);
		// Display the value
		g.setFont(Config.bigFont);
		fm = g.getFontMetrics();
		String s1 = String.valueOf(this.value);
		w = fm.stringWidth(s1);
		x = (getSize().width - w) / 2;
		y = (getSize().height + y + fm.getHeight()) / 2;
		g.drawString(s1, x, y);
	}

	public void setValue(int i) {
		this.value = i;
		repaint();
	}
}
