package display;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

/**
 * @author Fabien Dagnat <fabien.dagnat@imt-atlantique.fr>
 */
public class GraphicCanvas extends Canvas {
	private int angle = 0;
	private final String title;
	private Color arcColor = Color.blue;
	private Color segColor = Color.yellow;
	private int segStart = 9999;
	private int segEnd = 9999;
	private final static int Cx = 30;
	private final static int Cy = 55;
	private Image offscreen;
	private Dimension offscreensize;
	private Graphics offgraphics;

	GraphicCanvas(String title, Color c) {
		this.title = title;
		setSize(150, 180);
		this.arcColor = c;
	}

	@Override
	public void paint(Graphics g) {
		update(g);
	}

	public void setAngle(int a) {
		this.angle = a;
		repaint();
	}

	public void setColor(Color c) {
		setBackground(c);
		repaint();
	}

	public void setSegment(int start, int end, Color c) {
		this.segStart = start;
		this.segEnd = end;
		this.segColor = c;
	}

	@Override
	public synchronized void update(Graphics g) {
		Dimension d = getSize();
		if (this.offscreen == null || d.width != this.offscreensize.width
				|| d.height != this.offscreensize.height) {
			this.offscreen = createImage(d.width, d.height);
			this.offscreensize = d;
			this.offgraphics = this.offscreen.getGraphics();
			// this.offgraphics.setFont(getFont());
		}
		this.offgraphics.setColor(getBackground());
		this.offgraphics.fillRect(0, 0, d.width, d.height);

		// Display the title
		this.offgraphics.setColor(Color.black);
		this.offgraphics.setFont(Config.titleFont);
		FontMetrics fm = this.offgraphics.getFontMetrics();
		int w = fm.stringWidth(this.title);
		int h = fm.getHeight();
		int x = (getSize().width - w) / 2;
		int y = h;
		this.offgraphics.drawString(this.title, x, y);
		// this.offgraphics.drawLine(x, y + 3, x + w, y + 3);
		// Display the arc
		if (this.angle > 0) {
			if (this.angle < this.segStart || this.segStart == this.segEnd) {
				this.offgraphics.setColor(this.arcColor);
				this.offgraphics.fillArc(Cx, Cy, 90, 90, 0, this.angle);
			} else if (this.angle >= this.segStart && this.angle < this.segEnd) {
				this.offgraphics.setColor(this.arcColor);
				this.offgraphics.fillArc(Cx, Cy, 90, 90, 0, this.segStart);
				if (this.angle - this.segStart > 0) {
					this.offgraphics.setColor(this.segColor);
					this.offgraphics.fillArc(Cx, Cy, 90, 90, this.segStart, this.angle - this.segStart);
				}
			} else {
				this.offgraphics.setColor(this.arcColor);
				this.offgraphics.fillArc(Cx, Cy, 90, 90, 0, this.segStart);
				this.offgraphics.setColor(this.segColor);
				this.offgraphics.fillArc(Cx, Cy, 90, 90, this.segStart, this.segEnd - this.segStart);
				if (this.angle - this.segEnd > 0) {
					this.offgraphics.setColor(this.arcColor);
					this.offgraphics.fillArc(Cx, Cy, 90, 90, this.segEnd, this.angle - this.segEnd);
				}
			}
		}
		g.drawImage(this.offscreen, 0, 0, null);
	}
}
