/**
 * 
 */
package display;

import java.awt.Color;
import java.awt.Graphics;

import javax.swing.JPanel;

/**
 * Created by Fabien Dagnat <fabien.dagnat@imt-atlantique.fr> on 10-2017
 *
 */
public class Light extends JPanel {
	private static Color ON = Color.YELLOW;
	private static Color OFF = Color.WHITE;

	private boolean state = false;

	public synchronized void switchOn() {
		this.state = true;
		repaint();
	}

	public synchronized void switchOff() {
		this.state = false;
		repaint();
	}

	@Override
	public void paintComponent(Graphics g) {
		super.paintComponents(g);
		g.setColor(state ? ON : OFF);
		g.fillOval(92, 20, 40, 50);
		g.setColor(Color.BLACK);
		g.fillRect(102, 67, 20, 20);
	}
}
