

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;

import javax.imageio.ImageIO;

public class PhiloView extends Canvas {
	// Les états d'un philosophes
	public static int THINKING = 0;
	public static int HUNGRY = 1;
	public static int GOTRIGHT = 2;
	public static int EATING = 3;
	public static int GOTLEFT = 4;

	// Les images et leur initialisation
	private BufferedImage loadBufferedImage(String string) {
		try {
			return ImageIO.read(this.getClass().getResource(string));
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	private Image[] imgs = new Image[5];
	{
		imgs[THINKING] = loadBufferedImage("/images/thinking.gif");
		imgs[HUNGRY] = loadBufferedImage("/images/hungry.gif");
		imgs[GOTRIGHT] = loadBufferedImage("/images/gotright.gif");
		imgs[EATING] = loadBufferedImage("/images/eating.gif");
		imgs[GOTLEFT] = loadBufferedImage("/images/gotleft.gif");
	}

	// Philos info
	private final AffineTransform[] philPlace = new AffineTransform[Diner.NUMPHILS];
	private final int[] philState = new int[Diner.NUMPHILS];
	// Fork infos
	private final int[] forkOnTableX = new int[Diner.NUMPHILS];
	private final int[] forkOnTableY = new int[Diner.NUMPHILS];
	private final boolean[] forkOnTable = new boolean[Diner.NUMPHILS];

	private Image offscreen;
	private Dimension offscreensize;
	private Graphics2D offgraphics;

	public PhiloView() throws IOException {
		double radius = 100.0;
		double philWidth = imgs[0].getWidth(this);
		double philHeight = imgs[0].getHeight(this);
		double radians;

		for (int i = 0; i < Diner.NUMPHILS; i++) {
			this.philPlace[i] = new AffineTransform();
			radians = 2.0 * Math.PI * (1.0 - (double) i / (double) Diner.NUMPHILS);
			this.philPlace[i].rotate(radians);
			this.philPlace[i].translate(0, -radius);
			this.philPlace[i].translate(-philWidth / 2, -philHeight / 2);
		}

		radius = 35;
		for (int i = 0; i < Diner.NUMPHILS; i++) {
			radians = (2 * i + 1) * Math.PI / Diner.NUMPHILS;
			this.forkOnTableX[i] = (int) (-Math.sin(radians) * radius - 5);
			this.forkOnTableY[i] = (int) (-Math.cos(radians) * radius - 5);
			this.forkOnTable[i] = true;
		}
	}

	@Override
	public void paint(Graphics g) {
		update(g);
	}

	public synchronized void setFork(int id, boolean taken) {
		this.forkOnTable[id] = !taken;
	}

	public synchronized void setPhil(int id, int s) {
		this.philState[id] = s;
		repaint();
	}

	@Override
	public void update(Graphics g) {
		// Effacement de l'affichage précédent
		backdrop();
		// Les philosophes
		for (int i = 0; i < Diner.NUMPHILS; i++) {
			this.offgraphics.drawImage(imgs[this.philState[i]], this.philPlace[i], this);
		}
		// La table
		this.offgraphics.setColor(Color.red);
		this.offgraphics.fillOval(-45, -45, 90, 90);
		// Les fourchettes qui sont posées
		this.offgraphics.setColor(Color.black);
		for (int i = 0; i < Diner.NUMPHILS; i++) {
			if (this.forkOnTable[i])
				this.offgraphics.fillOval(this.forkOnTableX[i], this.forkOnTableY[i], 10, 10);
		}
		// Si on a atteint un deadlock
		if (deadlocked()) {
			this.offgraphics.setColor(Color.black);
			this.offgraphics.drawString("DEADLOCKED", -60, 0);
		}
		g.drawImage(this.offscreen, 0, 0, null);
	}

	private void backdrop() {
		Dimension d = getSize();
		if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
			this.offscreen = createImage(d.width, d.height);
			this.offscreensize = d;
			this.offgraphics = (Graphics2D) this.offscreen.getGraphics();
			this.offgraphics.setFont(new Font("Helvetica", Font.BOLD, 18));
			this.offgraphics.translate(d.width / 2, d.height / 2); // set origin
																	// to centre
		}
		this.offgraphics.setColor(Color.lightGray);
		this.offgraphics.fillRect(-d.width / 2, -d.height / 2, d.width, d.height);
	}

	private boolean deadlocked() {
		for (int state : this.philState)
			if (state != GOTRIGHT)
				return false;
		return true;
	}
}
