package rw_text;

public abstract class Worker extends Thread {
	/** restTime specify the amount of time the worker rests */
	private final int restTime;
	/** workTime specify the amount of time the worker works */
	private final int workTime;
	/** synchronization object */
	protected final Synchronizer synchro;

	protected Worker(Runnable task, String name, int workTime, int restTime, Synchronizer synchro) {
		super(task, name);
		this.workTime = workTime;
		this.restTime = restTime;
		this.synchro = synchro;
	}

	protected Worker(String name, int workTime, int restTime, Synchronizer synchro) {
		super(name);
		this.workTime = workTime;
		this.restTime = restTime;
		this.synchro = synchro;
	}

	protected void work() {
		waitFor(this.workTime);
	}

	protected void rest() {
		waitFor(this.restTime);
	}

	private static void waitFor(int waitingTime) {
		try {
			sleep(waitingTime);
		} catch (InterruptedException e) {
		}
	}
}
