package rw_ui;

import mvc.ListModel;
import rw_text.Synchronizer;

public class Application {
	public static void main(String[] args) {
		ListModel<String> workingList = new ListModel<>();
		ListModel<String> idleReaders = new ListModel<>();
		ListModel<String> idleWriters = new ListModel<>();
		RWFrame frame = new RWFrame(workingList, idleWriters, idleReaders);
		GraphicController controller = new GraphicController(workingList, idleWriters, idleReaders);
		Synchronizer synchro = new Synchronizer();
		frame.register(new Reader("Lecteur1", controller, synchro, 10000, 4000));
		frame.register(new Reader("Lecteur2", controller, synchro, 6000, 15000));
		frame.register(new Reader("Lecteur3", controller, synchro, 4000, 20000));
		frame.register(new Writer("Redacteur1", controller, synchro, 5000, 15000));
		frame.register(new Writer("Redacteur2", controller, synchro, 6000, 9000));

		System.out.println("Appuyez sur demarrer");
	}
}
