package demo;

/**
 * @author F. Dagnat
 * @version 1
 */

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import display.DisplayedNumber;
import display.DisplayedThread;

public class Main {

	public static void main(String args[]) {
		// Creating the model elements
		final Exemple truc = new Exemple();
		// Creating the threads
		DisplayedThread trucThread = new DisplayedThread(truc, 100, "Un nom");
		// IHM
		createFrame(truc, trucThread);
		// Starting the threads
		trucThread.start();
	}

	private static void createFrame(Exemple laVal, DisplayedThread leThread) {
		JFrame frame = new JFrame("Rollercoaster");
		JPanel grid = new JPanel();
		grid.setLayout(new GridLayout(1, 3));
		// Passenger part
		createPanel(leThread.getPanel(), laVal.getDisplayedNumber(), grid);
		// Positioning and packing
		frame.add(grid, "Center");
		frame.setPreferredSize(new Dimension(180, 360));
		frame.pack();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = frame.getSize();
		if (frameSize.height > screenSize.height)
			frameSize.height = screenSize.height;
		if (frameSize.width > screenSize.width)
			frameSize.width = screenSize.width;
		frame.setLocation((screenSize.width - frameSize.width) / 2,
				(screenSize.height - frameSize.height) / 2);
		frame.setVisible(true);
	}

	private static void createPanel(JPanel tp, DisplayedNumber nc, JPanel grid) {
		JPanel p1 = new JPanel();
		p1.add(nc, "Center");
		p1.add(tp, "South");
		grid.add(p1);
	}
}
